/**
 * @file    main.cpp
 * @author  jonnie Walker
 * @brief   ESP32c6_test
 * @version 0.1
 * @date 2024-10-8
 * 
 * @copyright Copyright (c) 2023
 * -------------------------------------------------------------------/
 * If you want to implement low power consumption function, please refer to the program
 */

#include "esp_task_wdt.h" 
#include "esp_sleep.h"


#define RGB_BUILTIN 8

//Set sleep time (microseconds)
//You can adjust the sleep time sleepTime value as needed
// uint64_t sleepTime = 20 * 1000000; // 20 seconds
uint64_t sleepTime = 1 * 60 * 60 * 1000000ULL;  //6 hours
const int sleepTimeS = 20;  //Set the sleep time to 10 seconds

void enterDeepSleep();//Enter deep sleep mode
void rgb_8();



void setup() {
  // put your setup code here, to run once:
Serial.begin(115200);


}

void loop() {
  // put your main code here, to run repeatedly:
 if (Serial.available() > 0) { 
    char data = Serial.read(); 
    //Serial.print("Received: ");
    //Serial.println(data); 
    if(data == 'A'){
     neopixelWrite(RGB_BUILTIN, 0, 0, 0);//closure RGB light
     delay(100);
     enterDeepSleep();
     Serial.println("CON1--------------------/");
    }
    else if(data == 'B'){
      
       Serial.println("CON2--------------------/");
    }
    else{
      Serial.println("QSZNTEC");
      Serial.println("Thank you for using our board, 2024-5-17 production. My name is JW !");
      Serial.println("Welcome to Intelligent Control Heights.");
      Serial.println("ESP32-C6-PLC-DEBUG!");

    }
  }

 rgb_8(); //Call RGB function


}
void rgb_8(){
    log_i("hello world");
    neopixelWrite(RGB_BUILTIN, 255, 0, 0);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 255, 165, 0);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 255, 255, 0);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 0, 255, 0);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 0, 127, 255);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 0, 0, 255);
    delay(500);
    neopixelWrite(RGB_BUILTIN, 139, 0, 255);
    delay(500);
}


/*
 Mode parameters:
 1.ESP_PD_DOMAIN_RTC_SLOW_MEM：RTC slow memory domain.
 2.ESP_PD_DOMAIN_RTC_FAST_MEM：RTC fast memory domain.
 3.ESP_PD_DOMAIN_RTC_PERIPH：RTC Peripheral domain.
 4.ESP_PD_DOMAIN_XTAL：Crystal oscillator domain.
 5.ESP_PD_DOMAIN_MAX：The upper limit of the domain parameter.

 例：esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH | ESP_PD_DOMAIN_RTC_SLOW_MEM, ESP_PD_OPTION_ON);//使用RTC外设和慢速存储器

*/
// Enter deep sleep mode, and after waking up, ESP32 will restart--------------------/
//Wake-up methods include: timer, GPIO, touch sensor.
void enterDeepSleep() {
 
 // jr6001_get(5,4);
  //delay(2000);
  //Configure the sleep mode and select the mode according to the project situation
  esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH, ESP_PD_OPTION_ON);
  esp_sleep_enable_timer_wakeup(sleepTime);//Enable timer wakeup

 // jr6001_get(5,4);
  esp_deep_sleep_start();// Enter deep sleep mode
  //esp_light_sleep_start();//light sleep mode
}
