/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  ESP32-C6_epd-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * -----------------------------edit-----------------------/
 *
 *
 *   It should be noted that the latest PCB has lithium battery under-voltage 
 *   protection and cuts off the LDO power supply when the battery voltage is lower than 3V. 
    This function is controlled through GPIO2 and does not affect the USB power supply. 
    However, when the USB is unplugged, it needs to be Only by pulling GPIO2 high can the LDO power supply be ensured.
    Friends who need to copy this project can add it to the code first, and the source code will be updated later.
 */



/* Includes ------------------------------------------------------------------*/
#include "DEV_Config.h"
#include "EPD.h"
#include "GUI_Paint.h"
#include "imagedata.h"
#include <stdlib.h>
#include <Adafruit_AHTX0.h>
#include <Adafruit_BMP280.h>
#include <OneButton.h> 


#define EINK_PWR_CTRL 8  
#define LED_RUN   4   //Running indicator light
#define LDO_POWER 2  //It does not affect the USB power supply, but when the USB is unplugged, GPIO2 needs to be pulled high to ensure LDO power supply.
                     //Implemented lithium battery under-voltage protection to cut off the LDO power supply when the battery voltage is lower than 3V

//#define BTN_IO3 3  
#define BTN_IO9 9  //Parallel function buttons GPIO3 and GPIO9

#define BAT_ADC 1   //Check battery voltage
float voltage1;


int temp1 ,hum1;
// Create an AHT20 object with the address 0x38
Adafruit_AHTX0 aht;

Adafruit_BMP280 bmp; // I2C
//Adafruit_BMP280 bmp(BMP_CS); // hardware SPI
//Adafruit_BMP280 bmp(BMP_CS, BMP_MOSI, BMP_MISO,  BMP_SCK);
int temp2,pres2,appsa2;

uint8_t count_i =1,count_r =0; //Button count value

 //Create new image cache
  UBYTE *BlackImage;

//--BUTTON--2----------Multi-function button-------------------------------------/
OneButton button1(BTN_IO9 , true);

//button----------/
void click1();
void doubleclick1();
void longPressStart1();
void longPress1();

void epd_display_sensor();
void aht20_data_f();
void bmp280_data_f();
void bat_adcread();

/* Entry point ----------------------------------------------------------------*/
void setup()
{
    Serial.begin(115200);
  // Initializes the I2C
    Wire.begin(6, 7); // SDA, SCL

   analogReadResolution(12); //Set the ADC resolution to 12 bits


  // Initializes the AHT20 sensor
    if (!aht.begin()) {
      Serial.println("AHT20 initialization failed!");
      while (1) delay(10);
    }
    Serial.println("AHT20 initialization success!");
  
  //----------------------------------------------------------/
  unsigned status;
  //status = bmp.begin(BMP280_ADDRESS_ALT, BMP280_CHIPID);
  status = bmp.begin(0x77);
  if (!status) {
    Serial.println(F("Could not find a valid BMP280 sensor, check wiring or "
                      "try a different address!"));
    Serial.print("SensorID was: 0x"); Serial.println(bmp.sensorID(),16);
    Serial.print("        ID of 0xFF probably means a bad address, a BMP 180 or BMP 085\n");
    Serial.print("   ID of 0x56-0x58 represents a BMP 280,\n");
    Serial.print("        ID of 0x60 represents a BME 280.\n");
    Serial.print("        ID of 0x61 represents a BME 680.\n");
    while (1) delay(10);
  }

  /* Default settings from datasheet. */
  bmp.setSampling(Adafruit_BMP280::MODE_NORMAL,     /* Operating Mode. */
                  Adafruit_BMP280::SAMPLING_X2,     /* Temp. oversampling */
                  Adafruit_BMP280::SAMPLING_X16,    /* Pressure oversampling */
                  Adafruit_BMP280::FILTER_X16,      /* Filtering. */
                  Adafruit_BMP280::STANDBY_MS_500); /* Standby time. */



   pinMode(BTN_IO9 , INPUT_PULLUP); //Set the button as an internal pull-up input
   pinMode(LED_RUN,OUTPUT);
   pinMode(LDO_POWER,OUTPUT);
   digitalWrite(LDO_POWER,HIGH);//A separate battery is powered, and GPIO2 is at the HIGH level.

  //------------------------init-----------------------------/
    pinMode(EINK_PWR_CTRL,OUTPUT);
    delay(100);
    digitalWrite(EINK_PWR_CTRL,LOW);//Turn on screen power
    delay(1000);

    printf("EPD_2IN9_V2_test Demo\r\n");
    DEV_Module_Init();

    printf("e-Paper Init and Clear...\r\n");
    EPD_2IN9_V2_Init();
    EPD_2IN9_V2_Clear();//E-paper initialization and clearing
    DEV_Delay_ms(500);
    
    
    //Button callback function---------------------------------------------/
    button1.attachClick(click1);
    button1.attachDoubleClick(doubleclick1);
    button1.attachLongPressStart(longPressStart1);
  //  button1.attachLongPressStop(longPressStop1);
  // button1.attachDuringLongPress(longPress1);

    
    /* you have to edit the startup_stm32fxxx.s file and set a big enough heap size */
    UWORD Imagesize = ((EPD_2IN9_V2_WIDTH % 8 == 0)? (EPD_2IN9_V2_WIDTH / 8 ): (EPD_2IN9_V2_WIDTH / 8 + 1)) * EPD_2IN9_V2_HEIGHT;
    if((BlackImage = (UBYTE *)malloc(Imagesize)) == NULL) {
        printf("Failed to apply for black memory...\r\n");
        while(1);
    }
    printf("Paint_NewImage\r\n");
    Paint_NewImage(BlackImage, EPD_2IN9_V2_WIDTH, EPD_2IN9_V2_HEIGHT, 270, WHITE);


 bmp280_data_f();
 aht20_data_f();

#if 1  // Draw on the image
   epd_display_sensor();

#endif

    printf("Clear...\r\n");
   // EPD_2IN9_V2_Init();//E-paper initialization and clearing
   // EPD_2IN9_V2_Clear();

    //printf("Goto Sleep...\r\n");
   // EPD_2IN9_V2_Sleep();
   // free(BlackImage);
  //  BlackImage = NULL;
}

/* The main loop -------------------------------------------------------------*/
void loop()
{
    //button1.tick();

    digitalWrite(LED_RUN,LOW);//Turn on screen power
    delay(1000);
    digitalWrite(LED_RUN,HIGH);
    delay(1000);
    
    bmp280_data_f();
    aht20_data_f();
    bat_adcread();
  //digitalRead(BTN_IO9) == LOW
  if(digitalRead(BTN_IO9) == LOW) {
    Serial.println("Button pressed");
    EPD_2IN9_V2_Init();
    EPD_2IN9_V2_Clear();//E-paper initialization and clearing
    DEV_Delay_ms(500);   
   
    epd_display_sensor();
    //count_i = 1;
  }
  /*
  else if(count_r == 7){
   Serial.println("Button2");


      count_r = 0;
  }
  else if(count_r == 6){ 
    Serial.println("Button long");


       count_r = 0;
   
  }
  */
}


void epd_display_sensor(){

   printf("Drawing\r\n");
   //1.Select image
    Paint_SelectImage(BlackImage);
    Paint_Clear(WHITE);

    Paint_DrawString_EN(120, 90, "MAKERGO", &Font16, GRAY4, GRAY1);
    //Paint_DrawString_EN(10, 20, "hello world", &Font12, WHITE, BLACK);
    
    Paint_DrawString_EN(25, 3, "Temperature", &Font12, WHITE, BLACK);
    //Paint_DrawNum(18, 17, 23.56, &Font16, BLACK, WHITE);
    Paint_DrawNum(36, 33, temp1, &Font16, GRAY4, GRAY2);
   // Paint_DrawString_CN(79, 29,"*", &Font12CN, BLACK, WHITE);
   // Paint_DrawString_EN(69, 33, ".", &Font12, WHITE, BLACK);
    Paint_DrawString_EN(68, 33, "*C", &Font16, WHITE, BLACK);


    Paint_DrawString_EN(25, 78, "Humidity", &Font12, WHITE, BLACK);
   // Paint_DrawNum(18, 88, 56.2, &Font16, BLACK, WHITE);
    Paint_DrawNum(36, 98, hum1, &Font16, GRAY4, GRAY2);
     //Paint_DrawString_CN(40, 29,".", &Font12CN, BLACK, WHITE);
   // Paint_DrawString_EN(40, 33, ".", &Font12, WHITE, BLACK);
    Paint_DrawString_EN(70, 98, "%", &Font16, WHITE, BLACK);



    Paint_DrawString_EN(120, 3, "Pressure", &Font12, WHITE, BLACK);
    Paint_DrawNum(122, 33, pres2, &Font16, GRAY4, GRAY2);
    Paint_DrawString_EN(189, 33, "Pa", &Font16, WHITE, BLACK);


    Paint_DrawString_EN(230, 3, "Approx-a", &Font12, WHITE, BLACK);
    Paint_DrawNum(235, 33, 4, &Font16, GRAY4, GRAY2);
   // Paint_DrawNum(200, 33, appsa2, &Font16, GRAY4, GRAY2);
    Paint_DrawString_EN(263, 33, "m", &Font16, WHITE, BLACK);


    Paint_DrawString_EN(234, 78, "TempB", &Font12, WHITE, BLACK);
    //Paint_DrawNum(200, 33, 12, &Font16, GRAY4, GRAY2);
    Paint_DrawNum(236, 98, temp2, &Font16, GRAY4, GRAY2);
    Paint_DrawString_EN(259, 98, "*C", &Font16, WHITE, BLACK);
    

    EPD_2IN9_V2_Display_Base(BlackImage);
    DEV_Delay_ms(2000);

}



void bat_adcread(){
 //Read the ADC value and convert it to voltage, print the result
  voltage1 = analogRead(BAT_ADC) * 3.3 / 4095.0;//Battery supply voltage reading
 // float voltage2 = analogRead(LDO_POWER) * 3.3 / 4095.0; //Battery under-voltage protection reads voltage protection pin, used to control LDO to turn on and off
  Serial.print("Voltage on GPIO1:  ");
  Serial.print(voltage1);
  Serial.println("V");
  //Serial.print("Voltage on GPIO2:  ");
 // Serial.print( voltage2);
 //Serial.println("V");
}




//Temperature and humidity sensor-------aht20----------/
void aht20_data_f(){
  sensors_event_t humidity, temp;
  aht.getEvent(&humidity, &temp); // Read the data
//Temperature and humidity
  temp1 = temp.temperature;
  hum1 = humidity.relative_humidity;

  Serial.print("Temperature: ");
  //Serial.print(temp.temperature);
  Serial.print(temp1);
  Serial.println(" °C");

  Serial.print("humidity: ");
  //Serial.print(humidity.relative_humidity);
  Serial.print(hum1);
  Serial.println(" %");

  //delay(2000);


}

//Atmospheric pressure sensor------------bmp280---------/
void bmp280_data_f(){

temp2 =bmp.readTemperature();
pres2 =bmp.readPressure();
appsa2 =bmp.readAltitude(1013.25);
     
    Serial.print(F("Temperature = "));
    //Serial.print(bmp.readTemperature());
    Serial.print(temp2);
    Serial.println(" *C");

    Serial.print(F("Pressure = "));
    //Serial.print(bmp.readPressure());
    Serial.print(pres2);
    Serial.println(" Pa");

    Serial.print(F("Approx altitude = "));
    //Serial.print(bmp.readAltitude(1013.25)); /* Adjusted to local forecast! */
    Serial.print(appsa2);
    Serial.println(" m");

    Serial.println();
   // delay(1000);



}

//button----------------2-----------------------------------------/
//This function will be called when button1 is pressed 1 time (instead of 2 times). press the button).
void click1() {
  Serial.println("Button 1 click.");
  //count_i++;
  count_i = 3;
}  

// This function will be called when button1 is pressed twice in a short period of time
void doubleclick1() {
  Serial.println("Button 1 doubleclick.");
  count_r = 7;

}  

// This function will be called once when button1 is pressed for a long time.
void longPressStart1() {
  Serial.println("Button 1 longPress start");
  //count_r = 8;
  count_r = 6;
} 

// This function will be called frequently when button1 is pressed for a long time.
//void longPress1() {
 // Serial.println("Button 1 longPress...");
//}  
// This function will be called once when button1 is pressed and released for a long time.
//void longPressStop1() {
 // Serial.println("Button 1 longPress stop");
//} 



