/* Includes ------------------------------------------------------------------*/
#include "DEV_Config.h"
#include "EPD.h"
#include "GUI_Paint.h"
#include "imagedata.h"
#include <stdlib.h>

/* Entry point ----------------------------------------------------------------*/
void setup()
{
  printf("EPD_2IN13D_test Demo\r\n");
  DEV_Module_Init();

  printf("e-Paper Init and Clear...\r\n");
  EPD_2IN13D_Init();
  EPD_2IN13D_Clear();
  DEV_Delay_ms(500);

  //Create a new image cache
  UBYTE *BlackImage;
  /* you have to edit the startup_stm32fxxx.s file and set a big enough heap size */
  UWORD Imagesize = ((EPD_2IN13D_WIDTH % 8 == 0) ? (EPD_2IN13D_WIDTH / 8 ) : (EPD_2IN13D_WIDTH / 8 + 1)) * EPD_2IN13D_HEIGHT;
  if ((BlackImage = (UBYTE *)malloc(Imagesize)) == NULL) {
    printf("Failed to apply for black memory...\r\n");
    while (1);
  }
  printf("Paint_NewImage\r\n");
  Paint_NewImage(BlackImage, EPD_2IN13D_WIDTH, EPD_2IN13D_HEIGHT, 270, WHITE);

#if 1   //show image for array    
  printf("show image for array\r\n");
  Paint_SelectImage(BlackImage);
  Paint_Clear(WHITE);
  Paint_DrawBitMap(gImage_2in13d);

  EPD_2IN13D_Display(BlackImage);
  DEV_Delay_ms(2000);
#endif

#if 1   // Drawing on the image
  printf("Drawing\r\n");
  //1.Select Image
  Paint_SelectImage(BlackImage);
  Paint_Clear(WHITE);

  // 2.Drawing on the image
  Paint_DrawString_EN(5, 5, "waveshare", &Font16, BLACK, WHITE);
  Paint_DrawNum(5, 25, 123456789, &Font16, BLACK, WHITE);
  Paint_DrawString_CN(5, 45, "你好abc", &Font12CN, BLACK, WHITE);
  Paint_DrawString_CN(5, 60, "微雪电子", &Font24CN, WHITE, BLACK);
  EPD_2IN13D_Display(BlackImage);
  DEV_Delay_ms(1000);

  Paint_Clear(WHITE);
  Paint_DrawPoint(5, 10, BLACK, DOT_PIXEL_1X1, DOT_STYLE_DFT);
  Paint_DrawPoint(5, 25, BLACK, DOT_PIXEL_2X2, DOT_STYLE_DFT);
  Paint_DrawPoint(5, 40, BLACK, DOT_PIXEL_3X3, DOT_STYLE_DFT);
  Paint_DrawPoint(5, 55, BLACK, DOT_PIXEL_4X4, DOT_STYLE_DFT);
  Paint_DrawLine(20, 10, 70, 60, BLACK, DOT_PIXEL_1X1, LINE_STYLE_SOLID);
  Paint_DrawLine(70, 10, 20, 60, BLACK, DOT_PIXEL_1X1, LINE_STYLE_SOLID);
  Paint_DrawLine(170, 15, 170, 55, BLACK, DOT_PIXEL_1X1, LINE_STYLE_DOTTED);
  Paint_DrawLine(150, 35, 190, 35, BLACK, DOT_PIXEL_1X1, LINE_STYLE_DOTTED);
  Paint_DrawRectangle(20, 10, 70, 60, BLACK, DOT_PIXEL_1X1, DRAW_FILL_EMPTY);
  Paint_DrawRectangle(85, 10, 130, 60, BLACK, DOT_PIXEL_1X1, DRAW_FILL_FULL);
  Paint_DrawCircle(170, 35, 20, BLACK, DOT_PIXEL_1X1, DRAW_FILL_EMPTY);
  Paint_DrawCircle(170, 80, 20, BLACK, DOT_PIXEL_1X1, DRAW_FILL_FULL);
  EPD_2IN13D_Display(BlackImage);
  DEV_Delay_ms(2000);
#endif

#if 0   //Partial refresh, example shows time        
  printf("Partial refresh\r\n");
  Paint_SelectImage(BlackImage);
  PAINT_TIME sPaint_time;
  sPaint_time.Hour = 12;
  sPaint_time.Min = 34;
  sPaint_time.Sec = 56;
  UBYTE num = 20;
  for (;;) {
    sPaint_time.Sec = sPaint_time.Sec + 1;
    if (sPaint_time.Sec == 60) {
      sPaint_time.Min = sPaint_time.Min + 1;
      sPaint_time.Sec = 0;
      if (sPaint_time.Min == 60) {
        sPaint_time.Hour =  sPaint_time.Hour + 1;
        sPaint_time.Min = 0;
        if (sPaint_time.Hour == 24) {
          sPaint_time.Hour = 0;
          sPaint_time.Min = 0;
          sPaint_time.Sec = 0;
        }
      }
    }
    Paint_ClearWindows(15, 65, 15 + Font20.Width * 7, 65 + Font20.Height, WHITE);
    Paint_DrawTime(15, 65, &sPaint_time, &Font20, WHITE, BLACK);

    num = num - 1;
    if (num == 0) {
      break;
    }
    EPD_2IN13D_DisplayPart(BlackImage);
    DEV_Delay_ms(500);//Analog clock 1s
  }

#endif
  printf("Clear...\r\n");
  EPD_2IN13D_Init();
  Paint_Clear(WHITE);
  Paint_SelectImage(BlackImage);
  Paint_DrawRectangle(0, 0, EPD_2IN13D_WIDTH, EPD_2IN13D_HEIGHT, BLACK, DOT_PIXEL_1X1, DRAW_FILL_FULL);
  EPD_2IN13D_Display(BlackImage);
  DEV_Delay_ms(1000);
  EPD_2IN13D_Clear();

  printf("Goto Sleep...\r\n");
  EPD_2IN13D_Sleep();
  free(BlackImage);
  BlackImage = NULL;
}

/* The main loop -------------------------------------------------------------*/
void loop()
{
  //
}
