/**
 * @file    main.cpp
 * @author  jonnie Walker
 * @brief   ESP32c6_test
 * @version 0.1
 * @date 2024-10-8
 * 
 * @copyright Copyright (c) 2023
 * -------------------------------------------------------------------/
 * 
 */
#include <WiFiManager.h>
#include <WiFi.h>
#include <NTPClient.h>
#include <RTClib.h> //esp32-RTC




//设置NTP服务器
const char *ntpServer = "pool.ntp.org";
const long  gmtOffset_sec = 28800; // 这里是你所在时区的偏移量，这里是东一区的偏移量
const int   daylightOffset_sec = 28800;
 //设置以秒为单位的偏移时间以调整您的时区，例如
  // GMT +1 = 3600
  // GMT +8 = 28800
  // GMT -1 = -3600
  // GMT 0 = 0

// Define struct to store time data
struct TimeData {
  uint8_t Hours;
  uint8_t Minutes;
  uint8_t Seconds;
  uint16_t Year;
  uint16_t Month;
  uint16_t Day;
};
TimeData currentTime;

char daysOfTheWeek[7][12] = {"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};


WiFiUDP ntpUDP;
//NTPClient timeClient(udp);
NTPClient timeClient(ntpUDP, ntpServer, gmtOffset_sec, daylightOffset_sec);
RTC_Millis rtc; // 使用ESP32内置的RTC_Millis

DateTime getNTPTime() {
  timeClient.update();
  time_t rawTime = timeClient.getEpochTime();
  return DateTime(rawTime);
}


// 创建连网全局对象
WiFiManager wifiManager;

void time_readupdate(uint8_t cont_t);

void setup() {
  // put your setup code here, to run once:
   Serial.begin(115200);
   while (!Serial) ; // Needed for Leonardo only

   // 尝试连接保存的WiFi网络--------------------------------------/
  if (!wifiManager.autoConnect("ES3C6-EPD-V2", "31415927")) {
    Serial.println("Failed to connect and hit timeout");
   // multi_module(7,100,4);
    delay(3000);
    ESP.restart();  // 重启设备
   // delay(5000);
  }
  // 如果连接成功，则显示网络信息
 // Serial.println("Connected to WiFi");
 // Serial.print("IP address: ");
 // Serial.println(WiFi.localIP());
  

  //----------RTC------time---------------------------/
   timeClient.begin();// 启动NTP客户端

   rtc.begin(getNTPTime());  // 同步RTC时间


}

void loop() {
  // put your main code here, to run repeatedly:


time_readupdate(2);
delay(1000);


}

void time_readupdate(uint8_t cont_t){

  DateTime now = rtc.now();
   
  currentTime.Hours = now.hour();
  currentTime.Minutes = now.minute();
  currentTime.Seconds = now.second();
  currentTime.Year = now.year();
  currentTime.Month = now.month();
  currentTime.Day = now.day();
  
    switch (cont_t)
    {
    case 2://串口打印-------------------------------/
      Serial.print(now.year(), DEC);
      Serial.print('/');
      Serial.print(now.month(), DEC);
      Serial.print('/');
      Serial.print(now.day(), DEC);
      Serial.print(" (");
      Serial.print(daysOfTheWeek[now.dayOfTheWeek()]);
      Serial.print(") ");
      Serial.print(now.hour(), DEC);
      Serial.print(':');
      Serial.print(now.minute(), DEC);
      Serial.print(':');
      Serial.print(now.second(), DEC);
      Serial.println();
      break;
    }

}

//从NTP服务器获取最新的时间----------------------------------------------------/
void printCurrentTime() {
  timeClient.update();
  // Get hours, minutes, and seconds
  currentTime.Hours = timeClient.getHours();
  currentTime.Minutes = timeClient.getMinutes();
  currentTime.Seconds = timeClient.getSeconds();

   // 检查是否读取到完整的时间数据
  if (currentTime.Hours >= 0 && currentTime.Minutes >= 0 && currentTime.Seconds >= 0) {
  
    // 将时间数据转换成字符串形式。调试时用
   //String timeString = String( currentTime.hours) + ":" + String(currentTime.minutes) + ":" + String(currentTime.seconds);
   // Serial.print("UTC time: ");
   // Serial.println(timeString); 

  }
}

