/*

 When you are not sure about your screen IIC address, you can use the following sample program for IIC address acquisition

 After connecting your device, burn the following sample program and open the serial monitor to obtain the IIC address of the current device
  A5----SCL
  A4----SDA



I2C device found at address 0x23  !
done
Scanning...
I2C device found at address 0x23  !
done
Scanning...
I2C device found at address 0x23  !
done

*/




#include <Wire.h>
 
void setup() {
 // Wire.begin();
  Wire.begin(6, 7); // SDA, SCL

  Serial.begin(115200);
  while (!Serial); 
  Serial.println("\nI2C Scanner");
}
 
void loop() {
  int nDevices = 0;
 
  Serial.println("Scanning...");
 
  for (byte address = 1; address < 127; ++address) {
    // The i2c_scanner uses the return value of
    // the Write.endTransmisstion to see if
    // a device did acknowledge to the address.
    Wire.beginTransmission(address);
    byte error = Wire.endTransmission();
 
    if (error == 0) {
      Serial.print("I2C device found at address 0x");
      if (address < 16) {
        Serial.print("0");
      }
      Serial.print(address, HEX);
      Serial.println("  !");
 
      ++nDevices;
    } else if (error == 4) {
      Serial.print("Unknown error at address 0x");
      if (address < 16) {
        Serial.print("0");
      }
      Serial.println(address, HEX);
    }
  }
  if (nDevices == 0) {
    Serial.println("No I2C devices found\n");
  } else {
    Serial.println("done\n");
  }
  delay(5000); // Wait 5 seconds for next scan
}
 
