// ESP32-C6/C5 RS485 Communication Example with Auto-Flow-Control Module
// Using HardwareSerial UART0 (GPIO20-RX, GPIO21-TX)

void setup() {
  // Start the serial for debugging (over USB)
  Serial.begin(115200);
  
  // Start the hardware serial port UART0 for RS485 communication
  // The baud rate must match your receiving device
  Serial0.begin(9600, SERIAL_8N1); // 9600 is an example, change as needed

  Serial.println("ESP32-C6 Auto RS485 Communication Started...");
  Serial.println("(No manual pin control needed!)");
}

void loop() {
  // 1. Send a message every 2 seconds
  // The auto-flow-control module will handle the direction automatically!
  //Serial0.println("Hello from ESP32-C6 (Auto Mode)!");
  Serial.println("Sent a message.");

  // 2. Check for any incoming data on the RS485 bus
  receiveMessage();

  delay(2000); // Wait for 2 seconds
}

void receiveMessage() {
  // Check if data is available on the RS485 bus
  if (Serial0.available()) {
    // Read the incoming data until a newline character is received
    String receivedData = Serial0.readStringUntil('\n');
    receivedData.trim(); // Remove any extra whitespace or carriage return

    // Print the received data to the debug serial monitor
    Serial0.print("Received: ");
    Serial0.println(receivedData);
  }
}