#include <HardwareSerial.h>


//#define RE_DE_PIN   6
#define DEVICE_ADDR 0x01  
#define BAUDRATE    9600

#define RELAY_BUILTIN  10
//#define RELAY_BUILTIN  9

HardwareSerial RS485(1);

void setup() {
  Serial.begin(115200);

  pinMode(RELAY_BUILTIN,OUTPUT);
  RS485.begin(BAUDRATE, SERIAL_8N1, 19, 18); // RX, TX   ------C6
  //RS485.begin(BAUDRATE, SERIAL_8N1, 4, 5); // RX, TX   ------C5

 // pinMode(RE_DE_PIN, OUTPUT);
  //digitalWrite(RE_DE_PIN, LOW);

 Serial.println("---A---------INIT------------/");
  
}

void loop() {
  if (RS485.available() > 0) {
    String data = RS485.readStringUntil('\n');
    data.trim();
    int addr = data.substring(0, data.indexOf(':')).toInt();
    
    if (addr == DEVICE_ADDR) {  // Response when address matching
      String cmd = data.substring(data.indexOf(':') + 1);
      String response = executeCommand(cmd);
      
      // ================= Response sending=================
      RS485.print(DEVICE_ADDR);
      RS485.print(":");
      RS485.println(response);
      RS485.flush();
      
      Serial.println(" RS485------------READ---------/");

    }
  }
}

//Instruction processing
String executeCommand(String cmd) {
  if (cmd == "LED_ON") {
    digitalWrite(RELAY_BUILTIN, HIGH);
    return "OK";
  } else if (cmd == "LED_OFF") {
    digitalWrite(RELAY_BUILTIN, LOW);
    return "OK";
  }
  return "ERROR";
}