#include <HardwareSerial.h>

//ESP32C6----------PIN---------/
//#define RELAY1_BUILTIN  10
//#define RELAY2_BUILTIN  11
//#define RELAY3_BUILTIN  6
//#define RELAY4_BUILTIN  2

//ESP32C5---------PIN----------/
#define RELAY1_BUILTIN  9
#define RELAY2_BUILTIN  10
#define RELAY3_BUILTIN  0
#define RELAY4_BUILTIN  26

#define BAUDRATE     9600 // 485 communication baud rate
#define DEVICE_ADDR 0x02

HardwareSerial RS485(1); // Use UART1

// =================init =================
void setup() {
  Serial.begin(115200);
  
  pinMode(RELAY1_BUILTIN,OUTPUT);
  pinMode(RELAY2_BUILTIN,OUTPUT);
  pinMode(RELAY3_BUILTIN,OUTPUT);
  pinMode(RELAY4_BUILTIN,OUTPUT);

  // RS485.begin(BAUDRATE, SERIAL_8N1, 19, 18); // RX, TX   ------C6
  RS485.begin(BAUDRATE, SERIAL_8N1, 4, 5); // RX, TX   ------C5
  
  Serial.print("Device B Ready. Addr:");
  Serial.println(DEVICE_ADDR, HEX);
}

// ================= 主循环 =================
void loop() {
  handleRS485Communication();
}

// ================= 通信处理函数 =================
void handleRS485Communication() {
  // 接收数据
  if (RS485.available() > 0) {
    String data = RS485.readStringUntil('\n');
    data.trim();
    int addr = data.substring(0, data.indexOf(':')).toInt();
    
    if (addr == DEVICE_ADDR) {  // Response when address matching
      String cmd = data.substring(data.indexOf(':') + 1);
      String response = executeCommand(cmd);
      
     // ================= Response sending =================
      RS485.print(DEVICE_ADDR);
      RS485.print(":");
      RS485.println(response);
      RS485.flush();
      
      Serial.println("RS485---------RED----------/");

    }
  }
}

// ================= Instruction processing=================
String executeCommand(String cmd) {
  if (cmd == "LED1_ON") {
    digitalWrite(RELAY1_BUILTIN, HIGH);
    return "OK";
  } else if (cmd == "LED1_OFF") {
    digitalWrite(RELAY1_BUILTIN, LOW);
    return "OK";
  }
  else if (cmd == "LED2_ON") {
    digitalWrite(RELAY2_BUILTIN, HIGH);
    return "OK";
  }
  else if (cmd == "LED2_OFF") {
    digitalWrite(RELAY2_BUILTIN, LOW);
    return "OK";
  }
  else if (cmd == "LED3_ON") {
    digitalWrite(RELAY3_BUILTIN, HIGH);
    return "OK";
  }
  else if (cmd == "LED3_OFF") {
    digitalWrite(RELAY3_BUILTIN, LOW);
    return "OK";
  }
  else if (cmd == "LED4_ON") {
    digitalWrite(RELAY4_BUILTIN, HIGH);
    return "OK";
  }
  else if (cmd == "LED4_OFF") {
    digitalWrite(RELAY4_BUILTIN, LOW);
    return "OK";
  }
  return "ERROR";
}

