# ESP-S3-EYE [[English](./README.md)]

该示例**仅适用于** [ESP32-S3-EYE](https://www.espressif.com/zh-hans/products/devkits) 开发板，能帮助你快速上手使用开发板，体验语音唤醒、语音命令识别、人脸检测和识别等功能。



## 运行示例

### 步骤1：设定唤醒词和命令词

该示例预设了中文和英文两套唤醒词和命令词。

#### 中文：

如果使用中文时，需要将 `sdkconfig.defaults`中的 [Line49~Line60](./sdkconfig.defaults#L49) 用“#”注释掉，并且把 [Line35~Line46](./sdkconfig.defaults#L35) 前的“#”去掉。*中文为默认设置，所以在默认情况下无需改动。*

中文的唤醒词为“Hi, 乐鑫”，命令词包括：“停止工作”、“仅显示”、“人脸识别”、“移动侦测”、“添加人脸”、“删除人脸”和“识别一下”。

#### 英文：

如果使用英文时，需要将 `sdkconfig.defaults`中的 [Line35~Line46](./sdkconfig.defaults#L35) 用“#”注释掉，并且把 [Line49~Line60](./sdkconfig.defaults#L49) 前的“#”去掉。

英文的唤醒词为“Hi, ESP”，命令词包括：“Stop Working”、“Display Only”、“Face Recognition”、“Motion Detection”、“Enter Face”、“Delete Face”和“Recognize Face”。

> 当然你也可以在 menuconfig 中选择其他唤醒词和命令词。



### 步骤2：设定目标芯片

打开终端，进入该示例，运行以下命令设定目标芯片（注意：仅支持 ESP32-S3）：

```shell
idf.py set-target esp32s3
```



### 步骤3：运行和监视

烧录程序，运行 IDF 监视器：

```shell
idf.py flash monitor
```



## 示例说明

### 工作模式

该示例共包含四个工作模式：“待机模式”、“实时显示”、“人脸识别”和“移动侦测”。上电后默认进入“待机模式”：

1. 待机模式：该模式下，LCD 屏幕上仅显示 Espressif Logo。该模式也是开发板上电以后的默认模式。
1. 实时显示：该模式下，LCD 屏幕上会实时显示摄像头采集的图片。
1. 人脸识别：该模式下，LCD 屏幕上会实时显示摄像头采集的图片。并且实时检测画面中的人脸，并显示检测框和关键点。通过按键和语音交互可以实现人脸识别相关的操作，详见下表：

| 操作     | 说明                                         | 按键触发 | 语音触发                               |
| :------- | :------------------------------------------- | :------- | :------------------------------------- |
| 识别人脸 | 识别当前画面中的人脸，并显示识别结果         | “PLAY”   | “Hi，乐鑫”唤醒后，说出命令词“识别一下” |
| 添加人脸 | 添加当前画面中的人脸，并显示添加的 ID 号     | “UP+”    | “Hi，乐鑫”唤醒后，说出命令词“添加人脸” |
| 删除人脸 | 删除人脸库中的最后一个 ID， 并显示剩余 ID 数 | “DN-”    | “Hi，乐鑫”唤醒后，说出命令词“删除人脸” |

4. 移动侦测：该模式下，LCD 屏幕上会实时显示摄像头采集的图片。并且实时检测画面中是否出现物体移动，如果物体移动，画面左上角会显示蓝点，反之则不会。



### 模式切换

模式切换可以通过语音和按键实现。



#### 通过语音

在任何时候都可以通过语音进行模式切换，对应的详细方法见下表：

| 模式     | 中文                                   | 英文                                          |
| :------- | -------------------------------------- | --------------------------------------------- |
| 待机模式 | “Hi，乐鑫”唤醒后，说出命令词“停止工作” | “Hi，ESP”唤醒后，说出命令词“Stop Working”     |
| 实时显示 | “Hi，乐鑫”唤醒后，说出命令词“仅显示”   | “Hi，ESP”唤醒后，说出命令词“Display Only”     |
| 人脸识别 | “Hi，乐鑫”唤醒后，说出命令词“人脸识别” | “Hi，ESP”唤醒后，说出命令词“Face Recognition” |
| 移动侦测 | “Hi，乐鑫”唤醒后，说出命令词“移动侦测” | “Hi，ESP”唤醒后，说出命令词“Motion Detection” |



#### 通过按键

在任何时候都可以通过按下”MENU“按键进行模式切换。模式之间会按照如下顺序循环切换：”待机模式“ > ”实时显示“ > ”人脸识别“ > ”移动侦测“，继续按下“MENU”按键会重新回到“待机模式”，以此往复。



### LED 交互

#### 语音反馈

当说出唤醒词并且唤醒成功，开发板上的 LED 灯亮起，表示等待命令词。此时，

- 如果6秒内说出命令词，并且正确识别，LED 灯会闪烁一秒后熄灭，回到待唤醒状态，
- 如果6秒内没有说出命令词或者没有说出正确的命令词，6秒后 LED 灯熄灭，回到待唤醒状态。



#### 按键反馈

当按下任意按键（不包括“boot”和“reset”），LED 灯会闪烁一秒。