/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief ESP32c6—BUTTON-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 */
#include <Adafruit_NeoPixel.h>

#define BUTTON_PIN 18
#define LED_PIN    21
#define NUMPIXELS  1 // WS2812B LED
#define ADC_PIN1   2
#define ADC_PIN2   0

Adafruit_NeoPixel pixels(NUMPIXELS, LED_PIN, NEO_GRB + NEO_KHZ800);

void setup() {
  Serial.begin(115200);
  pinMode(BUTTON_PIN, INPUT_PULLUP); //Set the button pin as an input and enable the internal pull-up resistor
  pixels.begin(); // init NeoPixel

  analogReadResolution(12); //Set the ADC resolution to 12 bits
}

void loop() {
  static uint32_t lastTime = 0;
  static int brightness = 0;
  static int fadeAmount = 5;

  // Detect button press
  if (digitalRead(BUTTON_PIN) == LOW) {
    Serial.println("Button pressed!");
    delay(200); // Simple debounce processing
  }

 // Breathing light effect
  uint32_t currentTime = millis();
  if (currentTime - lastTime > 30) {
    lastTime = currentTime;
    brightness += fadeAmount;
    if (brightness <= 0 || brightness >= 255) {
      fadeAmount = -fadeAmount;
    }
    pixels.setPixelColor(0, pixels.Color(brightness, brightness, 255)); // blue breathing light
    pixels.show();
  }

  //Read ADC value and print
  int adcValue1 = analogRead(ADC_PIN1);
  int adcValue2 = analogRead(ADC_PIN2);
  //float voltage2 = adcValue * (3.3 / 4095.0); // Convert ADC values to voltage values
  //float voltage0 = adcValue * (3.3 / 4095.0); // Convert ADC values to voltage values

  Serial.print("ADC Value on GPIO2: ");
  Serial.println(adcValue1);
  Serial.print("ADC Value on GPIO0: ");
  Serial.println(adcValue2);

  delay(100);
}
