/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief ESP32c6—BUTTON-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 *  describe:
 * Button detection: When GPIO18 detects a low level, it means that the button is pressed. 
 * At this time, a message will be printed through the serial port and the LED will be triggered to display different colors and breathing effects.
 * LED control: Use the Adafruit_NeoPixel library to control the WS2812B LED. First display red, green, blue, then do the blue breathing effect.
 * ADC reading: Read the analog values ​​of GPIO2 and GPIO0, convert them into voltage values ​​and print them through the serial port.
 */

#include <Adafruit_NeoPixel.h>

#define BUTTON_PIN 18
#define LED_PIN    21
#define NUMPIXELS  1 // WS2812B LED quantity
#define ADC_PIN1   2
#define ADC_PIN2   0



Adafruit_NeoPixel pixels(NUMPIXELS, LED_PIN, NEO_GRB + NEO_KHZ800);

void displayColors();
void display_tricolor();

void setup() {
  Serial.begin(115200);
  pinMode(BUTTON_PIN, INPUT_PULLUP); //Set the button as an internal pull-up input
  pixels.begin(); // init LED

  analogReadResolution(12); //Set the ADC resolution to 12 bits


  display_tricolor();
}

void loop() {
  //Button detection
  if (digitalRead(BUTTON_PIN) == LOW) {
    Serial.println("Button pressed");
    displayColors();
  }

  //Read the ADC value and convert it to voltage, print the result
  float voltage1 = analogRead(ADC_PIN1) * 3.3 / 4095.0;
  float voltage2 = analogRead(ADC_PIN2) * 3.3 / 4095.0;
  Serial.print("Voltage on GPIO2: ");
  Serial.println(voltage1);
  Serial.print("Voltage on GPIO0: ");
  Serial.println(voltage2);

  delay(1000); 
}

void displayColors() {
  
 //display_tricolor();

  //Blue breathing light effect
  for (int i = 0; i < 256; i++) {
    int color = i;
    pixels.setPixelColor(0, pixels.Color(0, 0, color));
    pixels.show();
    delay(10);
  }
  for (int i = 255; i >= 0; i--) {
    int color = i;
    pixels.setPixelColor(0, pixels.Color(0, 0, color));
    pixels.show();
    delay(10);
  }
}

void display_tricolor(){
// Display different colors
  pixels.setPixelColor(0, pixels.Color(255, 0, 0)); // red
  pixels.show();
  delay(500);
  pixels.setPixelColor(0, pixels.Color(0, 255, 0)); // green
  pixels.show();
  delay(500);
  pixels.setPixelColor(0, pixels.Color(0, 0, 255)); //blue
  pixels.show();
  delay(500);

}
