/*
1.睡眠程序：
enterDeepSleep() 函数用于配置和启用深度睡眠模式。您可以根据需要调整睡眠时间 sleepTime 的值。
在 setup() 函数中，我们初始化了串口以便调试输出。在 loop() 函数中，您可以编写您的应用程序逻辑，
并在完成后调用 enterDeepSleep() 进入深度睡眠模式。

在深度睡眠模式下，ESP32-S3会关闭大部分电源，并只保持RTC（实时时钟）外设的供电。当定时器超时后，
ESP32-S3将唤醒并从之前的状态继续执行代码。

请注意，进入深度睡眠模式后，ESP32-S3将重置其状态，因此您可能需要在唤醒后重新初始化任何必要的组件和变量

1.定时器唤醒


*/




#include <esp_sleep.h>

// 进入深度睡眠模式
void enterDeepSleep() {
  // 设置睡眠时间（微秒）
  uint64_t sleepTime = 10 * 1000000; // 10秒

  // 配置睡眠模式
  esp_sleep_pd_config(ESP_PD_DOMAIN_RTC_PERIPH, ESP_PD_OPTION_ON);
  esp_sleep_enable_timer_wakeup(sleepTime);//启用定时器唤醒

  // 进入深度睡眠模式
  esp_deep_sleep_start();
}

void setup() {
  Serial.begin(115200);
}

void loop() {
  // 执行您的代码逻辑

  // 进入深度睡眠模式
  enterDeepSleep();
}