/*
当运行长时间的程序时，可能会出现意外崩溃或死机等问题。
为了避免这种情况，我们可以使用看门狗定时器来监视系统的运行状态，并在系统停止响应时重新启动它

我们使用了 esp_task_wdt_init() 函数来初始化看门狗定时器，并设置了定时器的超时时间为 15 秒。
然后，在 loop() 函数中，我们使用 esp_task_wdt_reset() 函数来定期“喂狗”，以确保系统保持响应状态。

如果系统在 15 秒内未能响应，则会触发看门狗定时器，系统将自动重新启动。

需要注意的是，在使用看门狗定时器时，我们需要确保在程序的任何地方都不会阻塞时间太长，
否则定时器可能会错误地重置系统。此外，看门狗定时器只是一个应急措施，我们仍需要尽量避免程序出现崩溃或死机的情况。

*/
#include <esp_task_wdt.h>

#define WATCHDOG_TIMEOUT 15

void setup() {
  Serial.begin(115200);
  delay(1000);

  // 初始化看门狗定时器
  esp_task_wdt_init(WATCHDOG_TIMEOUT, true);
  Serial.println("Watchdog timer started.");
}

void loop() {
  // 定期喂狗
  esp_task_wdt_reset();

  // 这里写你的具体逻辑
}


