#include <HardwareSerial.h>

HardwareSerial mySerial(1); // 使用第二个硬件串行端口

void setup() {
  // 初始化串行通信，选择GPIO12作为RX, GPIO13作为TX
  mySerial.begin(115200, SERIAL_8N1, 12, 13);
  Serial.begin(115200); // 启动调试串行端口
}

void loop() {
  if (mySerial.available()) { // 检查是否有数据可读
    String data = mySerial.readString(); // 读取数据
    Serial.println(data); // 将数据输出到调试串行端口
  }

  if (Serial.available()) { // 检查调试串行端口是否有数据输入
    String data = Serial.readString(); // 读取数据
    mySerial.println(data); // 发送数据到通过GPIO连接的设备
  }
  mySerial.println("Test!");
}
