/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  ESP32-C6_Sensor-Test
 * @version 0.2
 * @date 2024-07-1
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 * Core control is ESP32-C6-mode-N4
 * 
 * I2C: Wire.begin(6, 7); // GPIO6为SDA，GPIO7为SCL
 * 
 * Sensor:
 * 1.BH1750
 * 2.AHT20
 * 3.SCD40/41
 * 4.QMI8658C
 * 
 * 
 * 
 */

#include <Wire.h>
#include "Adafruit_BH1750.h"
#include "Adafruit_AHTX0.h"
#include "SparkFun_SCD4x_Arduino_Library.h"

#define RUN_LED 5


void setup() {
  Serial.begin(115200);
  //Wire.begin(); // 初始化I2C
  Wire.begin(6, 7); // GPIO6为SDA，GPIO7为SCL

  // 初始化BH1750
  if (!lightSensor.begin()) {
    Serial.println("Could not find BH1750 sensor!");
  }

  // 初始化AHT20
  if (!aht.begin()) {
    Serial.println("Could not find AHT20 sensor!");
  }

  // 初始化SCD4x
  if (!mySCD4x.begin()) {
    Serial.println("Could not find SCD4x sensor!");
  }

  // 初始化QMI8658
  if (!qmi8658.begin()) {
    Serial.println("Could not find QMI8658 sensor!");
  }

}

void loop() {
 
}
