/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  ESP32-C6_MSensor-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 */

#include <Adafruit_AHTX0.h>

// Create an AHT20 object with the address 0x38
Adafruit_AHTX0 aht;

void setup() {
  Serial.begin(115200);
 // Initializes the I2C
  Wire.begin(6, 7); // SDA, SCL

 // Initializes the AHT20 sensor
  if (!aht.begin()) {
    Serial.println("AHT20 initialization failed!");
    while (1) delay(10);
  }
  Serial.println("AHT20 initialization success!");
}

void loop() {
  sensors_event_t humidity, temp;
  aht.getEvent(&humidity, &temp); // Read the data
//Temperature and humidity
  Serial.print("Temperature: ");
  Serial.print(temp.temperature);
  Serial.println(" °C");

  Serial.print("humidity: ");
  Serial.print(humidity.relative_humidity);
  Serial.println(" %");

  delay(2000);
}
