/**
 * @file main.cpp
 * @author Jonnie Walker iTE  
 * @brief  ESP32-C6_MSensor-Test 
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024  
 * 
 * --------------------------------------------------------------------/
 */

#define ADC_PIN 2 // Define the ADC pins to use
#define ADC_PIN_V2  0


void setup() {
  Serial.begin(115200); 
  analogReadResolution(12); // Set ADC resolution to 12 bits
}

void loop() {
  int adcValue = analogRead(ADC_PIN); 
  float voltage = adcValue * (3.3 / 4095.0); // Convert ADC values to voltage values

  Serial.print("ADC Value: ");
  Serial.print(adcValue);
  Serial.print(" - Voltage: ");
  Serial.print(voltage);
  Serial.println(" V");

  delay(1000); 
}