/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  ESP32-C6_MSensor-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 */


#include <Wire.h>
#include <BH1750.h>

// Create a BH1750 object
BH1750 lightMeter;

void setup() {
  Serial.begin(115200);

  // Initializes the I2C
  Wire.begin(6, 7); // SDA, SCL

 // Initializes the BH1750 sensor
  if (lightMeter.begin(BH1750::CONTINUOUS_HIGH_RES_MODE)) {
    Serial.println("BH1750 was successfully initialized!");
  } else {
    Serial.println("BH1750 failed to initialize!");
  }
}

void loop() {
  float lux = lightMeter.readLightLevel();
  if (lux != BH1750::UNCONFIGURED) {
    Serial.print("Light intensity: ");
    Serial.print(lux);
    Serial.println(" lx");
  } else {
    Serial.println("Read error, please check sensor!");
  }

  delay(500); 
}
