/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  2.8inch_ILI9341V_esp32c6-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 */

#include <TFT_Touch.h>

// These are the pins used to interface between the 2046 touch controller and Arduino Mega
#define DOUT 5  /* Data out pin (T_DO) of touch screen */
#define DIN  4  /* Data in pin (T_DIN) of touch screen */
#define DCS  11  /* Chip select pin (T_CS) of touch screen */
#define DCLK 8  /* Clock pin (T_CLK) of touch screen */

// These are the default min and maximum values, set to 0 and 4095 to test the screen
#define HMIN 0
#define HMAX 4095
#define VMIN 0
#define VMAX 4095
#define XYSWAP 0 // 0 or 1

// This is the screen size for the raw to coordinate transformation
// width and height specified for landscape orientation
#define HRES 320 /* Default screen resulution for X axis */
#define VRES 240 /* Default screen resulution for Y axis */

/* Create an instance of the touch screen library */
TFT_Touch touch = TFT_Touch(DCS, DCLK, DIN, DOUT);

void setup()
{
  Serial.begin(115200);
  touch.setCal(HMIN, HMAX, VMIN, VMAX, HRES, VRES, XYSWAP); // Raw xmin, xmax, ymin, ymax, width, height
  touch.setRotation(1);
}

/* Main program */
void loop()
{
  unsigned int X_Raw;
  unsigned int Y_Raw;

  /* Check if the touch screen is currently pressed*/
  // Raw and coordinate values are stored within library at this instant
  // for later retrieval by GetRaw and GetCoord functions.
  // This avoids getting duff values returned
  if (touch.Pressed()) // Note this function updates coordinates stored within library variables
  {
    /* Read the current X and Y axis as raw co-ordinates at the last touch time*/
    // The values returned were captured when Pressed() was called!
    
    X_Raw = touch.RawX();
    Y_Raw = touch.RawY();

    /* Output the results to the serial port */
    Serial.print("Raw x,y = ");
    Serial.print(X_Raw);
    Serial.print(",");
    Serial.println(Y_Raw);
    delay(10);
  }
  delay(10);
}

