/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  2.8inch_ILI9341V_Touch-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024    EDITOR
 * 
 * --------------------------------------------------------------------/
 */

#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>

#include <TFT_Touch.h>

// Define the screen SPI pin
#define TFT_CS   21
#define TFT_RST  22
#define TFT_DC   3  //20
#define TFT_MOSI 18  // SDA
//#define TFT_MISO 20
#define TFT_CLK  19  // SCK
#define TFT_LED  23  //The LEDA pin is connected to GPIO23


// These are the pins used to interface between the 2046 touch controller and Arduino Mega
#define DOUT 5  /* Data out pin (T_DO) of touch screen */
#define DIN  4  /* Data in pin (T_DIN) of touch screen */
#define DCS  11  /* Chip select pin (T_CS) of touch screen */
#define DCLK 8  /* Clock pin (T_CLK) of touch screen */

// These are the default min and maximum values, set to 0 and 4095 to test the screen
#define HMIN 0
#define HMAX 4095
#define VMIN 0
#define VMAX 4095
#define XYSWAP 0 // 0 or 1

// This is the screen size for the raw to coordinate transformation
// width and height specified for landscape orientation
#define HRES 320 /* Default screen resulution for X axis */
#define VRES 240 /* Default screen resulution for Y axis */

/* Create an instance of the touch screen library */
TFT_Touch touch = TFT_Touch(DCS, DCLK, DIN, DOUT);


// Initializes the Adafruit_ILI9341 object
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_MOSI, TFT_CLK, TFT_RST,-1);
// Adafruit_ILI9341(int8_t _CS, int8_t _DC, int8_t _MOSI, int8_t _SCLK,
                 //  int8_t _RST = -1, int8_t _MISO = -1);


void setup() {
  Serial.begin(115200);
  while (!Serial && (millis() <= 1000));

  pinMode(TFT_LED, OUTPUT); 
  digitalWrite(TFT_LED, HIGH); 
  
  // ledcSetup(0, 5000, 8);  // Channel 0, 5 kHz PWM, 8 bit resolution
   //ledcAttachPin(TFT_LED, 0);  // Bind GPIO23 to channel 0
   //ledcWrite(0, 200); // Change the PWM duty cycle dutyCycle
  
  touch.setCal(HMIN, HMAX, VMIN, VMAX, HRES, VRES, XYSWAP); // Raw xmin, xmax, ymin, ymax, width, height
  touch.setRotation(1);// Set TFT the screen to landscape orientation

  tft.begin();
  tft.setRotation(1); // Adjust the screen orientation as required
  tft.fillScreen(ILI9341_BLACK);  // Set the screen background to black
  tft.setTextColor(ILI9341_WHITE);   // Set the text color to white

  tft.setTextSize(3); // Set the text size
 
  tft.setCursor(10, 10); // Set the start position of the text
  tft.println("QSZNTEC! ");

 
}

void loop() {
  unsigned int X_Raw;
  unsigned int Y_Raw;
  static int lastX = -1, lastY = -1; // Used to store the last touch coordinates

  /* Check if the touch screen is currently pressed*/
  // Raw and coordinate values are stored within library at this instant
  // for later retrieval by GetRaw and GetCoord functions.
  // This avoids getting duff values returned
  if (touch.Pressed()) // Note this function updates coordinates stored within library variables
  {
    /* Read the current X and Y axis as raw co-ordinates at the last touch time*/
    // The values returned were captured when Pressed() was called!
    X_Raw = touch.RawX();
    Y_Raw = touch.RawY();
   
   // Convert the original coordinates to screen coordinates
   
    int x = map(X_Raw, HMIN, HMAX, 0, tft.width());
    int y = map(Y_Raw, VMIN, VMAX, 0, tft.height());

   // Draw a small dot at the touch point
   // tft.fillCircle(x, y, 2, ILI9341_WHITE); // Color and size can be adjusted
   if (lastX != -1 && lastY != -1) {
      // Draw lines from the previous point to the current point
      tft.drawLine(lastX, lastY, x, y, ILI9341_WHITE);
    }

     // Update the previous touch coordinates
    lastX = x;
    lastY = y;




    /* Output the results to the serial port */
    Serial.print("Raw x,y = ");
    Serial.print(X_Raw);
    Serial.print(",");
    Serial.println(Y_Raw);
    delay(10);
  }else {
    // If there is no touch, reset the previous coordinate
    lastX = -1;
    lastY = -1;
  }
  delay(10);

}
