/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  2.8inch_ILI9341V_esp32c6-Test
 * @version 0.1
 * @date 2024-07-9
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 */


#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_ILI9341.h>


// Define the SPI pin
#define TFT_CS   21
#define TFT_RST  22
#define TFT_DC   3  
#define TFT_MOSI 18  // SDA
//#define TFT_MISO 20
#define TFT_CLK  19  // SCK
#define TFT_LED  23  // LEDA pin is connected to GPIO23

#define ADC_PIN 0 // Define the ADC pins to use
//#define ADC_PIN_V2  2


// Initializes the Adafruit_ILI9341 object
Adafruit_ILI9341 tft = Adafruit_ILI9341(TFT_CS, TFT_DC, TFT_MOSI, TFT_CLK, TFT_RST,-1);
// Adafruit_ILI9341(int8_t _CS, int8_t _DC, int8_t _MOSI, int8_t _SCLK,
                 //  int8_t _RST = -1, int8_t _MISO = -1);


void setup() {
  Serial.begin(115200);
  while (!Serial && (millis() <= 1000));

  pinMode(TFT_LED, OUTPUT); // Set the LEDA pin to output
  digitalWrite(TFT_LED, HIGH); // Turn on the backlight

  analogReadResolution(12); // Set ADC resolution to 12 bits


  tft.begin();// Initialize the screen
  tft.setRotation(1);// Adjust the screen orientation as required
  tft.fillScreen(ILI9341_BLACK);// Set the screen background to black
  tft.setTextColor(ILI9341_WHITE); // Set the text color to white 
  tft.setTextSize(3);// Set the text size


// User-defined display of text on the screen--------------------------------------/
  tft.setCursor(10, 10); // Set the start position of the text
  tft.println("Hello, World!");

 
}

void loop() {
  int adcValue = analogRead(ADC_PIN); 
  float voltage = adcValue * (3.3 / 4095.0); // Convert ADC values to voltage values

  Serial.print("ADC Value: ");
  Serial.print(adcValue);
  Serial.print(" - Voltage: ");
  Serial.print(voltage);
  Serial.println(" V");

  tft.setCursor(30, 100); // Set the start position of the text
  tft.setTextSize(2);// Set the text size
  tft.fillRect(137,100,100,20,ILI9341_BLACK);
  tft.print("Sensorlx:");
  tft.println(voltage);
  delay(500);


}