/**
 /// * 
 * 
 * The program was edited by jonnie Walker
 * 
 * Date:2024/7/23
 * 
 */

#include <Adafruit_NeoPixel.h>

//#define PIN 8
#define PIN 10
#define NUM_LEDS 1
Adafruit_NeoPixel strip = Adafruit_NeoPixel(NUM_LEDS, PIN, NEO_GRBW + NEO_KHZ800);

int delay_ms = 5; // Set the blinking delay time

void setup() {
  strip.begin(); // Initializes the WS2812B RGB light
  strip.show();  // Displays the initialization color
}

void loop() {
// Control color change flicker
  for(int i=0; i<256; i++) {
    colorWipe(strip.Color(i, 0, 0)); // red
    delay(delay_ms);
  }
  for(int i=0; i<256; i++) {
    colorWipe(strip.Color(0, i, 0)); // green
    delay(delay_ms);
  }
  for(int i=0; i<256; i++) {
    colorWipe(strip.Color(0, 0, i)); //blue
    delay(delay_ms);
  }
  for(int i=255; i>=0; i--) {
    colorWipe(strip.Color(i, i, i)); // white
    delay(delay_ms);
  }
}

// Control the color change of the lamp
void colorWipe(uint32_t color) {
  for(int i=0; i<strip.numPixels(); i++) {
    strip.setPixelColor(i, color);
  }
  strip.show();
}